% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-compareModels.R
\name{compareModels,ModelComparison,SurvivalModel-method}
\alias{compareModels,ModelComparison,SurvivalModel-method}
\title{Compare Two \code{SurivalModel} Objects, Returing A \code{ModelComparison} Object
With Statistics Comparing the Performance of Each Model.}
\usage{
\S4method{compareModels}{ModelComparison,SurvivalModel}(model1, model2, model2Name)
}
\arguments{
\item{model1}{An object inherting from the \code{SurvivalModel} class.}

\item{model2}{Another object inherting from the \code{SurvivalModel} class}

\item{model2Name}{A \code{character} vector with the name of the second model.}
}
\value{
A \code{ModelComparison} object with statistics comparing the two models.
}
\description{
Compare Two \code{SurivalModel} Objects, Returing A \code{ModelComparison} Object
With Statistics Comparing the Performance of Each Model.
}
\examples{
data(sampleValPCOSPmodel)
data(sampleClinicalModel)
data(sampleCohortList)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train the models
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Predict risk/risk-class
clinicalPredCohortL <- predictClasses(sampleCohortList[c('PCSI', 'TCGA')],
  model=trainedClinicalModel)

# Validate the models
validatedClinicalModel <- validateModel(trainedClinicalModel,
  valData=clinicalPredCohortL)

# Compare the models
modelComp <- compareModels(sampleValPCOSPmodel, validatedClinicalModel)
head(modelComp)

# Compare model comparison to another model
modelCompComp <- compareModels(modelComp, sampleValPCOSPmodel)

}
