% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-ClinicalModel.R
\name{ClinicalModel}
\alias{ClinicalModel}
\title{Constructor for the ClinicalModel Class}
\usage{
ClinicalModel(trainData, formula, minDaysSurvived = 365, ..., randomSeed)
}
\arguments{
\item{trainData}{A \code{SurvivalExperiment} or \code{CohortList} object to construct
a clinical model using}

\item{formula}{A \code{formula} object or a \code{character} vector coercible to one.
All columns specified in the formula must be in the colData slot of the
all \code{SurvivalExperiment}s in trainData.}

\item{minDaysSurvived}{An \code{integer} specifying the minimum number of days
required to be 'good' prognosis. Default is 365.}

\item{...}{Force all subsequent parameters to be named. Not used.}

\item{randomSeed}{An \code{integer} randomSeed that was used to train the model.
Users should specify this when initializing a model to ensure
reproducibilty.}
}
\value{
A \code{ClinicalModel} object.
}
\description{
Constructor for the ClinicalModel Class
}
\examples{
data(sampleICGCmicro)
set.seed(1987)
clinicalModel <- ClinicalModel(sampleICGCmicro,
  formula='prognosis ~ sex + age + T + N + M + grade', randomSeed=1987)

}
