% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Opt2Shift.R
\name{Opt2Shift}
\alias{Opt2Shift}
\title{Run the 2-opt algorithm to improve the optimal order searching of the Extended Nearest Insertion}
\usage{
Opt2Shift(Data,N=20000,Seq,Ndg=3,NChun=4, NCThre=1000, RdmStart=FALSE)
}
\arguments{
\item{Data}{gene-by-sample matrix or isoform-by-sample matrix. It should be rescaled to values bwteen
[-1,1].}

\item{N,NCThre}{The 2-opt algorithm will stop if N iterations has been performed or if the optimal order
remains unchanged for over NCThre iterations.}

\item{Seq}{a vector indicates the sample order obtained from the ENI.}

\item{Ndg}{degree of polynomial.}

\item{NChun}{number of starting points for polynomial fitting.}

\item{RdmStart}{whether the start points are randomly selected.}
}
\value{
This function performs the
the 2-opt algorithm to improve the optimal order searching of the Extended Nearest Insertion (ENI).
In each iteration, the function will randomly choose two points (samples), the flip the samples
between these two points. The new order will be adapted if it provides smaller SPR MSE.
The output returns the optimal order and its SPR MSE.
}
\description{
Run the 2-opt algorithm to improve the optimal order searching of the Extended Nearest Insertion
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
res <- ImpShift(rbind(aa,bb,cc), NChun=2)
res2 <- Opt2Shift(rbind(aa,bb,cc), NChun=2, N=50, Seq=res)
}
\author{
Ning Leng
}

