% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfcensus.R
\name{tfcensus_download}
\alias{tfcensus_download}
\title{Downloads the list of transcription factors from TF census}
\usage{
tfcensus_download()
}
\value{
A data frame (tibble) listing transcription factors.
}
\description{
Vaquerizas et al. published in 2009 a list of transcription factors. This
function retrieves Supplementary Table 2 from the article
(\url{http://www.nature.com/nrg/journal/v10/n4/index.html}).
}
\examples{
tfcensus <- tfcensus_download()
tfcensus
# # A tibble: 1,987 x 7
#    Class `Ensembl ID` `IPI ID` `Interpro DBD` `Interpro DNA-b.
#    <chr> <chr>        <chr>    <chr>          <chr>
#  1 a     ENSG0000000. IPI0021. NA             IPR001289
#  2 a     ENSG0000000. IPI0004. IPR000047;IPR. NA
#  3 a     ENSG0000000. IPI0001. IPR001356;IPR. NA
#  4 a     ENSG0000000. IPI0029. IPR000910;IPR. NA
#  5 a     ENSG0000000. IPI0001. IPR007087;IPR. IPR006794
# # . with 1,977 more rows, and 2 more variables: `HGNC symbol` <chr>,
# # `Tissue-specificity` <chr>

}
