% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preppi.R
\name{preppi_download}
\alias{preppi_download}
\title{Interactions from PrePPI}
\usage{
preppi_download(...)
}
\arguments{
\item{...}{Minimum values for the scores. The available scores are:
str, protpep, str_max, red, ort, phy, coexp, go, total, exp and final.
Furthermore, an operator can be passed, either \code{.op = '&'} or
\code{.op = '|'}, which is then used for combined filtering by
multiple scores.}
}
\value{
A data frame (tibble) of interactions with scores, databases
and literature references.
}
\description{
Retrieves predicted protein-protein interactions from the PrePPI
database (\url{http://honig.c2b2.columbia.edu/preppi}). The interactions
in this table are supposed to be correct with a > 0.5 probability.
}
\details{
PrePPI is a combination of many prediction methods, each resulting a
score. For an explanation of the scores see
\url{https://honiglab.c2b2.columbia.edu/hfpd/help/Manual.html}.
The minimum, median and maximum values of the scores:

\if{html}{\out{<div class="sourceCode">}}\preformatted{| Score   | Minimum | Median   | Maximum            |
| ------- | ------- | -------- | ------------------ |
| str     |       0 |     5.5  |           6,495    |
| protpep |       0 |     3.53 |          38,138    |
| str_max |       0 |    17.9  |          38,138    |
| red     |       0 |     1.25 |              24.4  |
| ort     |       0 |     0    |           5,000    |
| phy     |       0 |     2.42 |               2.42 |
| coexp   |       0 |     2.77 |              45.3  |
| go      |       0 |     5.86 |             181    |
| total   |       0 | 1,292    | 106,197,000,000    |
| exp     |       1 |   958    |           4,626    |
| final   |     600 | 1,778    |            4.91e14 |
}\if{html}{\out{</div>}}
}
\examples{
preppi <- preppi_download()
preppi
# # A tibble: 1,545,710 x 15
#    prot1 prot2 str_score protpep_score str_max_score red_score ort_score
#    <chr> <chr>     <dbl>         <dbl>         <dbl>     <dbl>     <dbl>
#  1 Q131. P146.     18.6           6.45         18.6      4.25      0.615
#  2 P064. Q96N.      1.83         14.3          14.3      4.25      0
#  3 Q7Z6. Q8NC.      4.57          0             4.57     0         0
#  4 P370. P154.    485.            0           485.       1.77      0.615
#  5 O004. Q9NR.     34.0           0            34.0      0.512     0
# # . with 1,545,700 more rows, and 8 more variables: phy_score <dbl>,
# #   coexp_score <dbl>, go_score <dbl>, total_score <dbl>, dbs <chr>,
# #   pubs <chr>, exp_score <dbl>, final_score <dbl>

}
\seealso{
\code{\link{preppi_filter}}
}
