% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{ontology_name_id}
\alias{ontology_name_id}
\title{Translate between ontology IDs and names}
\usage{
ontology_name_id(terms, ids = TRUE, db_key = "go_basic")
}
\arguments{
\item{terms}{Character: ontology IDs or term names.}

\item{ids}{Logical: the output should contain IDs or term names.}

\item{db_key}{Character: key to identify the ontology database. For the
available keys see \code{\link{omnipath_show_db}}.}
}
\value{
Character vector of ontology IDs or term names.
}
\description{
Makes sure that the output contains only valid IDs or term names. The
input can be a mixture of IDs and names. The order of the input won't
be preserved in the output.
}
\examples{
ontology_name_id(c('mitochondrion inheritance', 'reproduction'))
# [1] "GO:0000001" "GO:0000003"
ontology_name_id(c('GO:0000001', 'reproduction'), ids = FALSE)
# [1] "mitochondrion inheritance" "reproduction"

}
