% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{omnipath_load_config}
\alias{omnipath_load_config}
\alias{load_config}
\title{Load the package configuration from a config file}
\usage{
omnipath_load_config(path = NULL, title = "default", user = FALSE, ...)

load_config(
  path = NULL,
  title = "default",
  user = FALSE,
  pkg = "OmnipathR",
  ...
)
}
\arguments{
\item{path}{Path to the config file.}

\item{title}{Load the config under this title. One config file might
contain multple configurations, each identified by a title. If the
title is not available the first section of the config file will be
used.}

\item{user}{Force to use the user level config even if a config file
exists in the current directory. By default, the local config files
have prioroty over the user level config.}

\item{...}{Passed to \code{yaml::yaml.load_file}.}

\item{pkg}{Character: name of the package}
}
\value{
Invisibly returns the config as a list.
}
\description{
Load the package configuration from a config file

Load the coniguration of a certain package
}
\examples{
\dontrun{
# load the config from a custom config file:
omnipath_load_config(path = 'my_custom_omnipath_config.yml')
}

}
