% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmdb.R
\name{hmdb_table}
\alias{hmdb_table}
\title{Download a HMDB XML file and process it into a table}
\usage{
hmdb_table(dataset = "metabolites", fields = NULL)
}
\arguments{
\item{dataset}{Character: name of an HMDB XML dataset, such as
"metabolites", "proteins", "urine", "serum", "csf", "saliva", "feces",
"sweat".}

\item{fields}{Character: fields to extract from the XML. This is a very
minimal parser that is able to extract the text content of simple fields
and multiple value fields which contain a list of leaves within one
container tag under the record tag. A full list of fields available in
HMDB is available by the \code{\link{hmdb_protein_fields}} and \code{
\link{hmdb_metabolite_fields}} functions. By default, all fields
available in the dataset are extracted.}
}
\value{
A data frame (tibble) with each column corresponding to a field.
}
\description{
Download a HMDB XML file and process it into a table
}
\examples{
hmdb_table()

}
\seealso{
\itemize{
    \item{\code{\link{hmdb_protein_fields}}}
    \item{\code{\link{hmdb_metabolite_fields}}}
}
}
