% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercell.R
\name{filter_intercell}
\alias{filter_intercell}
\title{Filter intercell annotations}
\usage{
filter_intercell(
  data,
  categories = NULL,
  resources = NULL,
  parent = NULL,
  scope = NULL,
  aspect = NULL,
  source = NULL,
  transmitter = NULL,
  receiver = NULL,
  secreted = NULL,
  plasma_membrane_peripheral = NULL,
  plasma_membrane_transmembrane = NULL,
  proteins = NULL,
  causality = NULL,
  topology = NULL,
  ...
)
}
\arguments{
\item{data}{An intercell annotation data frame as provided by
\code{\link{intercell}}.}

\item{categories}{Character: allow only these values in the \code{category}
column.}

\item{resources}{Character: allow records only from these resources.}

\item{parent}{Character: filter for records with these parent categories.}

\item{scope}{Character: filter for records with these annotation scopes.
Possible values are \code{generic} and \code{specific}.}

\item{aspect}{Character: filter for records with these annotation aspects.
Possible values are \code{functional} and \code{locational}.}

\item{source}{Character: filter for records with these annotation sources.
Possible values are \code{composite} and \code{resource_specific}.}

\item{transmitter}{Logical: if \code{TRUE} only transmitters, if
\code{FALSE} only non-transmitters will be selected, if \code{NULL}
it has no effect.}

\item{receiver}{Logical: works the same way as \code{transmitters}.}

\item{secreted}{Logical: works the same way as \code{transmitters}.}

\item{plasma_membrane_peripheral}{Logical: works the same way as
\code{transmitters}.}

\item{plasma_membrane_transmembrane}{Logical: works the same way as
\code{transmitters}.}

\item{proteins}{Character: filter for annotations of these proteins.
Gene symbols or UniProt IDs can be used.}

\item{causality}{Character: filter for records with these causal roles.
Possible values are \code{transmitter} and \code{receiver}. The filter
applied simultaneously to the \code{transmitter} and \code{receiver}
arguments, it's just a different notation for the same thing.}

\item{topology}{Character: filter for records with these localization
topologies. Possible values are \code{secreced},
\code{plasma_membrane_peripheral} and
\code{plasma_membrane_transmembrane}; the shorter notations \code{sec},
\code{pmp} and \code{pmtm} can be used. Has the same effect as the
logical type arguments, just uses a different notation.}

\item{...}{Ignored.}
}
\value{
The intercell annotation data frame filtered according to the
    specified conditions.
}
\description{
Filters a data frame retrieved by \code{\link{intercell}}.
}
\examples{
ic <- intercell()
ic <- filter_intercell(
    ic,
    transmitter = TRUE,
    secreted = TRUE,
    scope = "specific"
)

}
\seealso{
\itemize{
    \item{\code{\link{intercell}}}
    \item{\code{\link{intercell_categories}}}
    \item{\code{\link{intercell_generic_categories}}}
    \item{\code{\link{intercell_summary}}}
    \item{\code{\link{intercell_network}}}
}
}
