% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_interactions.R
\name{print_path_vs}
\alias{print_path_vs}
\title{Print networks paths given by node sequence}
\usage{
print_path_vs(nodes, G)
}
\arguments{
\item{nodes}{An igraph node sequence object.}

\item{G}{An igraph graph object (from ptms or interactions)}
}
\value{
Returns `NULL`.
}
\description{
Prints the interactions in the path in a nice format.
}
\examples{
interactions <- omnipath(resources = "SignaLink3")
OPI_g <- interaction_graph(interactions = interactions)
print_path_vs(
    igraph::all_shortest_paths(
        OPI_g,
        from = 'TYRO3',
        to = 'STAT3'
    )$vpath,
    OPI_g
)
enzsub <- enzyme_substrate(resources=c("PhosphoSite", "SIGNOR"))
enzsub_g <- enzsub_graph(enzsub)
print_path_vs(
    igraph::all_shortest_paths(
        enzsub_g,
        from = 'SRC',
        to = 'STAT1'
    )$res,
    enzsub_g
)

}
\seealso{
\code{\link{print_path_es}}
}
