% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_expression_data}
\alias{nichenet_expression_data}
\title{Expression data from ligand-receptor perturbation experiments used by
NicheNet}
\usage{
nichenet_expression_data()
}
\value{
Nested list, each element contains a data frame of processed
    expression data and key variables about the experiment.
}
\description{
NicheNet uses expression data from a collection of published ligand or
receptor KO or perturbation experiments to build its model. This function
retrieves the original expression data, deposited in Zenodo
(\url{https://zenodo.org/record/3260758}).
}
\examples{
exp_data <- nichenet_expression_data()
head(names(exp_data))
# [1] "bmp4_tgfb"     "tgfb_bmp4"     "nodal_Nodal"   "spectrum_Il4"
# [5] "spectrum_Tnf"  "spectrum_Ifng"
purrr::map_chr(head(exp_data), 'from')
#     bmp4_tgfb     tgfb_bmp4   nodal_Nodal  spectrum_Il4  spectrum_Tnf
#       "BMP4"       "TGFB1"       "NODAL"         "IL4"         "TNF"
# spectrum_Ifng
#       "IFNG"

}
