% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.R
\name{kegg_open}
\alias{kegg_open}
\title{Open a KEGG Pathway diagram in the browser}
\usage{
kegg_open(pathway_id)
}
\arguments{
\item{pathway_id}{Character: a KEGG Pathway identifier, e.g. "hsa04710".
For a complete list of IDs see \code{\link{kegg_pathway_list}}.}
}
\value{
Returns \code{NULL}.
}
\description{
Open a KEGG Pathway diagram in the browser
}
\details{
To open URLs in the web browser the "browser" option must to be set to a
a valid executable. You can check the value of this option by
\code{getOption("browser")}. If your browser is firefox and the executable
is located in the system path, you can set the option to point to it:
\code{options(browser = "firefox")}. To make it a permanent setting, you
can also include this in your \code{.Rprofile} file.
}
\examples{
if(any(getOption('browser') != '')) kegg_open('hsa04710')

}
\seealso{
\itemize{
    \item{\code{\link{kegg_pathway_list}}}
    \item{\code{\link{kegg_picture}}}
    \item{\code{\link{kegg_info}}}
}
}
