% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intercell.R
\name{intercell}
\alias{intercell}
\alias{import_omnipath_intercell}
\title{Cell-cell communication roles from OmniPath}
\usage{
intercell(
  categories = NULL,
  parent = NULL,
  scope = NULL,
  aspect = NULL,
  source = NULL,
  transmitter = NULL,
  receiver = NULL,
  secreted = NULL,
  plasma_membrane_peripheral = NULL,
  plasma_membrane_transmembrane = NULL,
  proteins = NULL,
  topology = NULL,
  causality = NULL,
  consensus_percentile = NULL,
  loc_consensus_percentile = NULL,
  ...
)
}
\arguments{
\item{categories}{vector containing the categories to be retrieved.
All the genes belonging to those categories will be returned. For
further information about the categories see
\code{\link{get_intercell_categories}}.}

\item{parent}{vector containing the parent classes to be retrieved.
All the genes belonging to those classes will be returned. For
furter information about the main classes see
\code{\link{get_intercell_categories}}.}

\item{scope}{either `specific` or `generic`}

\item{aspect}{either `locational` or `functional`}

\item{source}{either `resource_specific` or `composite`}

\item{transmitter}{logical, include only transmitters i.e. proteins
delivering signal from a cell to its environment.}

\item{receiver}{logical, include only receivers i.e. proteins delivering
signal to the cell from its environment.}

\item{secreted}{logical, include only secreted proteins}

\item{plasma_membrane_peripheral}{logical, include only plasma membrane
peripheral membrane proteins.}

\item{plasma_membrane_transmembrane}{logical, include only plasma membrane
transmembrane proteins.}

\item{proteins}{limit the query to certain proteins}

\item{topology}{topology categories: one or more of `secreted` (sec),
`plasma_membrane_peripheral` (pmp), `plasma_membrane_transmembrane`
(pmtm) (both short or long notation can be used).}

\item{causality}{`transmitter` (trans), `receiver` (rec) or `both` (both
short or long notation can be used).}

\item{consensus_percentile}{Numeric: a percentile cut off for the
consensus score of generic categories. The consensus score is the
number of resources supporting the classification of an entity into a
category based on combined information of many resources. Here you can
apply a cut-off, keeping only the annotations supported by a higher
number of resources than a certain percentile of each category. If
\code{NULL} no filtering will be performed. The value is either in the
0-1 range, or will be divided by 100 if greater than 1. The
percentiles will be calculated against the generic composite
categories and then will be applied to their resource specific
annotations and specific child categories.}

\item{loc_consensus_percentile}{Numeric: similar to
\code{consensus_percentile} for major localizations. For example, with
a value of 50, the secreted, plasma membrane transmembrane or
peripheral attributes will be true only where at least 50 percent
of the resources support these.}

\item{...}{
  Arguments passed on to \code{\link[=omnipath_query]{omnipath_query}}
  \describe{
    \item{\code{organism}}{Character or integer: name or NCBI Taxonomy ID of the
organism. OmniPath is built of human data, and the web service provides
orthology translated interactions and enzyme-substrate relationships for
mouse and rat. For other organisms and query types, orthology
translation will be called automatically on the downloaded human data
before returning the result.}
    \item{\code{resources}}{Character vector: name of one or more resources. Restrict
the data to these resources. For a complete list of available resources,
call the `<query_type>_resources` functions for the query type of
interst.}
    \item{\code{fields}}{Character vector: additional fields to include in the result.
For a list of available fields, call `query_info("interactions")`.}
    \item{\code{default_fields}}{Logical: if TRUE, the default fields will be included.}
    \item{\code{silent}}{Logical: if TRUE, no messages will be printed. By default a
summary message is printed upon successful download.}
    \item{\code{logicals}}{Character vector: fields to be cast to logical.}
    \item{\code{format}}{Character: if "json", JSON will be retrieved and processed
into a nested list; any other value will return data frame.}
    \item{\code{download_args}}{List: parameters to pass to the download function,
which is \code{readr::read_tsv} by default, and
\code{jsonlite::stream_in} if \code{format = "json"}. Note: as these are
both wrapped into a downloader using \code{curl::curl}, a curl handle
can be also passed here under the name \code{handle}.}
    \item{\code{license}}{Character: license restrictions. By default, data from
resources allowing "academic" use is returned by OmniPath. If you use
the data for work in a company, you can provide "commercial" or
"for-profit", which will restrict the data to those records which are
supported by resources that allow for-profit use.}
    \item{\code{password}}{Character: password for the OmniPath web service. You can
provide a special password here which enables the use of `license =
"ignore"` option, completely bypassing the license filter.}
    \item{\code{exclude}}{Character vector: resource or dataset names to be excluded.
The data will be filtered after download to remove records of the
excluded datasets and resources.}
    \item{\code{json_param}}{List: parameters to pass to the `jsonlite::fromJSON` when
processing JSON columns embedded in the downloaded data. Such columns
are "extra_attrs" and "evidences". These are optional columns which
provide a lot of extra details about interactions.}
    \item{\code{strict_evidences}}{Logical: reconstruct the "sources" and "references"
columns of interaction data frames based on the "evidences" column,
strictly filtering them to the queried datasets and resources. Without
this, the "sources" and "references" fields for each record might
contain information for datasets and resources other than the queried
ones, because the downloaded records are a result of a simple filtering
of an already integrated data frame.}
    \item{\code{genesymbol_resource}}{Character: "uniprot" (default) or "ensembl". The
OmniPath web service uses the primary gene symbols as provided by
UniProt. By passing "ensembl" here, the UniProt gene symbols will be
replaced by the ones used in Ensembl. This translation results in a loss
of a few records, and multiplication of another few records due to
ambiguous translation.}
    \item{\code{cache}}{Logical: use caching, load data from and save to the. The cache
directory by default belongs to the user, located in the user's default
cache directory, and named "OmnipathR". Find out about it by
\code{getOption("omnipathr.cachedir")}. Can be changed by
\code{\link{omnipath_set_cachedir}}.}
  }}
}
\value{
A data frame of intercellular communication roles.
}
\description{
Roles of proteins in intercellular communication from the
\url{https://omnipathdb.org/intercell} endpoint of the OmniPath web service.
It provides information on the roles in inter-cellular signaling. E.g. if
a protein is a ligand, a receptor, an extracellular matrix (ECM) component,
etc.
}
\examples{
ecm_proteins <- intercell(categories = "ecm")

}
\seealso{
\itemize{
    \item{\code{\link{intercell_network}}}
    \item{\code{\link{intercell_consensus_filter}}}
    \item{\code{\link{filter_intercell}}}
    \item{\code{\link{intercell_categories}}}
    \item{\code{\link{intercell_generic_categories}}}
    \item{\code{\link{intercell_resources}}}
    \item{\code{\link{intercell_summary}}}
    \item{\code{\link{intercell_network}}}
}
}
