% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidences.R
\name{from_evidences}
\alias{from_evidences}
\title{Recreate interaction records from evidences columns}
\usage{
from_evidences(data, .keep = FALSE)
}
\arguments{
\item{data}{An interaction data frame from the OmniPath web service with
evidences column.}

\item{.keep}{Logical: keep the original "evidences" column when unnesting to
separate columns by direction.}
}
\value{
A copy of the input data frame with all the standard columns
    describing the direction, effect, resources and references of the
    interactions recreated based on the contents of the nested list
    evidences column(s).
}
\description{
Recreate interaction records from evidences columns
}
\details{
The OmniPath interaction data frames specify interactions primarily by
three columns: "is_directed", "is_stimulation" and "is_inhibition".
Besides these, there are the "sources" and "references" columns that are
always included in data frames created by OmnipathR and list the resources
and literature references for each interaction, respectively. The optional
"evidences" column is required to find out which of the resources and
references support the direction or effect sign of the interaction. To
properly recover information for arbitrary subsets of resources or
datasets, the evidences can be filtered first, and then the standard
data frame columns can be reconstructed from the selected evidences.
This function is able to do the latter. It expects either an "evidences"
column or evidences in their wide format 4 columns layout. It overwrites
the standard columns of interaction records based on data extracted from
the evidences, including the "curation_effort" and "consensus..." columns.

\strong{Note:} The "curation_effort" might be calculated slightly
differently from the version included in the OmniPath web service. Here
we count the resources and the also add the number of references for each
resource. E.g. a resource without any literatur reference counts as 1,
while a resource with 3 references adds 4 to the value of the curation
effort.

\strong{Note:} If the "evidences" column has been already unnested to
multiple columns ("positive", "negative", etc.) by
\code{\link{unnest_evidences}}, then these will be used;
otherwise, the column will be unnested within this function.

\strong{Note:} This function (or rather its wrapper,
\code{\link{only_from}}) is automatically applied if the `strict_evidences`
argument is passed to any function querying interactions (see
\code{\link{omnipath-interactions}}).
}
\examples{
\dontrun{
ci <- collectri(evidences = TRUE)
ci <- unnest_evidences(ci)
ci <- filter_evidences(datasets = 'collectri')
ci <- from_evidences(ci)
# the three lines above are equivalent to only_from(ci)
# and all the four lines above is equivalent to:
# collectri(strict_evidences = TRUE)
}

}
\seealso{
\itemize{
    \item{\code{\link{filter_evidences}}}
    \item{\code{\link{unnest_evidences}}}
    \item{\code{\link{only_from}}}
}
}
