% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nullDistri.R
\name{nullDistri}
\alias{nullDistri}
\title{Probability of one group being upregulated under null}
\usage{
nullDistri(ppnull)
}
\arguments{
\item{ppnull}{a list returned by \code{\link{postProbNull}} or
\code{\link{OVESEGtest}}.}
}
\value{
a numeric vector indicating probabilities of each group being
upregulated than others under null hypotheses.
}
\description{
This function estimates probabilities of any one group being upregulated
than other groups under null hypotheses.
}
\details{
The probability of one group being upregulated under null
hypotheses is calculated by accumulating and normalizing genewise posterior
probability of null hypotheses. The group with higher probability tends to
get more False Positive MGs.
}
\examples{
data(RocheBT)
ppnull <- postProbNull(RocheBT$y, RocheBT$group, alpha='moderated')
pk <- nullDistri(ppnull)
}
