% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/script.R
\name{OSTA.data}
\alias{OSTA.data}
\alias{OSTA.data_list}
\alias{OSTA.data_load}
\title{Datasets used in OSTA}
\usage{
OSTA.data_list(url = "https://osf.io/5n4q3")

OSTA.data_load(
  id,
  bfc = BiocFileCache(),
  url = "https://osf.io/5n4q3",
  pol = TRUE,
  mol = TRUE
)
}
\arguments{
\item{url}{character string; an OSF identifier
(passed to \code{\link[osfr]{osf_retrieve_node}})}

\item{id}{character string; dataset identifier
(see \code{\link{OSTA.data_list}} for valid options)}

\item{bfc}{\code{\link[BiocFileCache]{BiocFileCache}}
instance giving the location of files stored on disk}

\item{pol, mol}{logical scalar; specifies whether or not 
to retrieve boundaries and molecules, respectively}
}
\value{
\itemize{
\item{\code{OSTA.data_list} 
  returns a character vector of 
  currently available datasets}
\item{\code{OSTA.data_load} 
  return a character string;
  the path to a Zip archive}}
}
\description{
Datasets used in OSTA
}
\details{
The following datasets are currently available:\itemize{
\item{Janesick \emph{et al.}:
  Visium, Xenium and Chromium
  data on human colorectal cancer;
  source: \href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE243280}{GSE243280}
  source chromium h5: \href{https://www.10xgenomics.com/products/xenium-in-situ/preview-dataset-human-breast}{10x Genomics}}
\item{Oliveira \emph{et al.}:
  Visium, Visium HD, Xenium and Chromium
  data on human breast cancer;
  source: \href{https://www.10xgenomics.com/products/visium-hd-spatial-gene-expression/dataset-human-crc}{10x Genomics}}
\item{1k-plex CosMx data on 2 mouse brain sections
  (coronal hippocampus and cortex, coronal hemisphere)
  source: \href{https://nanostring.com/products/cosmx-spatial-molecular-imager/ffpe-dataset/cosmx-smi-mouse-brain-ffpe-dataset}{NanoString}}
\item{6k-plex CosMx data on human brain (frontal cortex);
  source: \href{https://nanostring.com/products/cosmx-spatial-molecular-imager/ffpe-dataset/human-frontal-cortex-ffpe-dataset}{NanoString}}}
}
\examples{
# view available datasets
OSTA.data_list()

# retrieve 10x Xenium data from Oliveira et al.
id <- "Xenium_HumanColon_Oliveira"
pa <- OSTA.data_load(id)

# unpack & view contents
td <- tempfile()
dir.create(td)
unzip(pa, exdir=td)
list.files(td)

# read into 'SpatialExperiment'
library(SpatialExperimentIO)
(spe <- readXeniumSXE(td))
}
\references{
Oliveira \emph{et al.} 
Characterization of immune cell populations in the tumor 
microenvironment of colorectal cancer using high definition 
spatial profiling. \emph{Nature Genetics} 57, 1512–1523 (2025).

Janesick \emph{et al.} 
High resolution mapping of the tumor microenvironment 
using integrated single-cell, spatial and in situ analysis.
\emph{Nature Communications} 14, 8353 (2023).
}
