% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverage_helpers.R
\name{windowPerReadLength}
\alias{windowPerReadLength}
\title{Find proportion of reads per position per read length in window}
\usage{
windowPerReadLength(
  grl,
  tx = NULL,
  reads,
  pShifted = TRUE,
  upstream = ifelse(!is.null(tx), ifelse(pShifted, 5, 20), min(ifelse(pShifted, 5, 20),
    0)),
  downstream = ifelse(pShifted, 20, 5),
  acceptedLengths = NULL,
  zeroPosition = upstream,
  scoring = "transcriptNormalized",
  weight = "score",
  drop.zero.dt = FALSE,
  append.zeroes = FALSE,
  windows = startRegion(grl, tx, TRUE, upstream, downstream)
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object
with usually either leaders, cds', 3' utrs or ORFs}

\item{tx}{default NULL, a GRangesList of transcripts or (container region),
names of tx must contain all grl names. The names of grl can also be the
ORFik orf names. that is "txName_id"}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}}, or
precomputed coverage as \code{\link{covRleList}}
(where names of covRle objects are readlengths) of
RiboSeq, RnaSeq etc. \cr Weigths for scoring is default the 'score'
column in 'reads'. Can also be random access paths to bigWig or fstwig file.
Do not use random access for more than a few genes, then loading the entire files
is usually better.}

\item{pShifted}{a logical (TRUE), are Ribo-seq reads p-shifted to size
1 width reads? If upstream and downstream is set, this argument is
irrelevant. So set to FALSE if this is not p-shifted Ribo-seq.}

\item{upstream}{an integer (5), relative region to get upstream from. Default:
\code{ifelse(!is.null(tx), ifelse(pShifted, 5, 20), min(ifelse(pShifted, 5, 20), 0))}}

\item{downstream}{an integer (20), relative region to get downstream from. Default:
\code{ifelse(pShifted, 20, 5)}}

\item{acceptedLengths}{an integer vector (NULL), the read lengths accepted.
Default NULL, means all lengths accepted.}

\item{zeroPosition}{an integer DEFAULT (upstream), what is the center point?
Like leaders and cds combination, then 0 is the TIS and -1 is last base in leader.
NOTE!: if windows have different widths, this will be ignored.}

\item{scoring}{a character (transcriptNormalized), which meta coverage scoring ?
one of (zscore, transcriptNormalized, mean, median, sum, sumLength, fracPos),
see ?coverageScorings for more info. Use to decide a scoring of hits
per position for metacoverage etc. Set to NULL if you do not want meta coverage,
but instead want per gene per position raw counts.}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{append.zeroes}{logical, default FALSE. If TRUE and drop.zero.dt
is TRUE and all windows have equal length, it will add back 0 values after transformation.
Sometimes needed for correct plots, if TRUE, will call abort if not all
windows are equal length!}

\item{windows}{the GRangesList windows to actually check, default:
\code{startRegion(grl, tx, TRUE, upstream, downstream)}.}
}
\value{
a data.table with 4 columns: position (in window), score,
fraction (read length). If score is NULL, will also return genes (index of grl).
A note is that if no coverage is found, it returns an empty data.table.
}
\description{
This is defined as:
Fraction of reads  per read length, per position in whole window (defined
by upstream and downstream)
If tx is not NULL, it gives a metaWindow, centered around startSite of
grl from upstream and downstream. If tx is NULL, it will use only downstream
, since it has no reference on how to find upstream region.
The exception is when upstream is negative, that is,
going into downstream region of the object.
}
\details{
Careful when you create windows where not all transcripts are long enough,
this function usually is used first with filterTranscripts to make sure they
are of all of valid length!
}
\examples{
cds <- GRangesList(tx1 = GRanges("1", 100:129, "+"))
tx <- GRangesList(tx1 = GRanges("1", 80:129, "+"))
reads <- GRanges("1", seq(79,129, 3), "+")
windowPerReadLength(cds, tx, reads, scoring = "sum")
windowPerReadLength(cds, tx, reads, scoring = "transcriptNormalized")
}
\seealso{
Other coverage: 
\code{\link{coverageScorings}()},
\code{\link{metaWindow}()},
\code{\link{regionPerReadLength}()},
\code{\link{scaledWindowPositions}()}
}
\concept{coverage}
