% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_helpers.R
\name{unlistGrl}
\alias{unlistGrl}
\title{Safe unlist}
\usage{
unlistGrl(grl)
}
\arguments{
\item{grl}{a GRangesList}
}
\value{
a GRanges object
}
\description{
Same as [AnnotationDbi::unlist2()], keeps names correctly.
Two differences is that if grl have no names, it will not
make integer names, but keep them as null. Also if the GRangesList has names
, and also the GRanges groups, then the GRanges group names will be kept.
}
\examples{
ORF <- GRanges(seqnames = "1",
               ranges = IRanges(start = c(1, 10, 20),
                                end = c(5, 15, 25)),
               strand = "+")
# GRL named, GR not named
grl <- GRangesList(tx1_1 = ORF)
res <- unlistGrl(grl)
res_original <- unlist(grl)
identical(res, res_original) # TRUE

# GRL not named, GR not named
grl_no_names <- grl
names(grl_no_names) <- NULL
unlistGrl(grl_no_names)
res <- unlistGrl(grl_no_names)
res_original <- unlist(grl_no_names)
identical(res, res_original) # TRUE

# GRL named, GR named
grl_names_gr_names <- unlistGrl(grl)
grl_names_gr_names <-
 split(grl_names_gr_names, names(grl_names_gr_names))
res <- unlistGrl(grl_names_gr_names)
res_original <- unlist(grl_names_gr_names)
identical(res, res_original) # FALSE

# GRL not named, GR named
grl_not_names_gr_names <- grl_names_gr_names
names(grl_not_names_gr_names) <- NULL
res <- unlistGrl(grl_not_names_gr_names)
res_original <- unlist(grl_not_names_gr_names)
identical(res, res_original) # TRUE


}
