% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_helpers.R
\name{tile1}
\alias{tile1}
\title{Tile each GRangesList group to 1-base resolution.}
\usage{
tile1(
  grl,
  sort.on.return = TRUE,
  matchNaming = TRUE,
  is.sorted = TRUE,
  mergeEqualNamed = TRUE
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} object with names.}

\item{sort.on.return}{logical (TRUE), should the groups be
sorted before return (Negative ranges should be in decreasing order).
Makes it a bit slower, but much safer for downstream analysis.}

\item{matchNaming}{logical (TRUE), should groups keep unlisted names
and meta data.(This make the list very big, for > 100K groups)}

\item{is.sorted}{logical (TRUE), grl is presorted
(negative coordinates are decreasing). Set to FALSE if they are not,
else output will most likely be wrong!}

\item{mergeEqualNamed}{logical, default TRUE. Merge groups with equal name}
}
\value{
a GRangesList grouped by original group, tiled to 1. Groups with identical names
will be merged unless mergeEqualNamed is FALSE!
}
\description{
Will tile a GRangesList into single bp resolution, each group of the list
will be splited by positions of 1. Returned values are sorted as the same
groups as the original GRangesList, except they are in bp resolutions.
This is not supported originally by GenomicRanges for GRangesList.
}
\examples{
gr1 <- GRanges("1", ranges = IRanges(start = c(1, 10, 20),
                                     end = c(5, 15, 25)),
               strand = "+")
gr2 <- GRanges("1", ranges = IRanges(start = c(20, 30, 40),
                                     end = c(25, 35, 45)),
               strand = "+")
names(gr1) = rep("tx1_1", 3)
names(gr2) = rep("tx1_2", 3)
grl <- GRangesList(tx1_1 = gr1, tx1_2 = gr2)
tile1(grl)

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{extendTrailers}()},
\code{\link{reduceKeepAttr}()},
\code{\link{txSeqsFromFa}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
