% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/txdbHelpers.R
\name{loadTxdb}
\alias{loadTxdb}
\title{General loader for txdb}
\usage{
loadTxdb(txdb, chrStyle = NULL, organism = NA, chrominfo = NULL)
}
\arguments{
\item{txdb}{a TxDb file, a path to one of:
(.gtf ,.gff, .gff2, .gff2, .db or .sqlite)
or an ORFik experiment}

\item{chrStyle}{a GRanges object, TxDb, FaFile,
, a \code{\link{seqlevelsStyle}} or \code{\link{Seqinfo}}.
(Default: NULL) to get seqlevelsStyle from. In addition if it
is a Seqinfo object, seqinfo will be updated.
Example of seqlevelsStyle update:
Is chromosome 1 called chr1 or 1,
 is mitocondrial chromosome called MT or chrM etc.
Will use 1st seqlevel-style if more are present.
Like: c("NCBI", "UCSC") -> pick "NCBI"}

\item{organism}{character, default NA. Scientific name of organism.
Only used if input is path to gff.}

\item{chrominfo}{Seqinfo object, default NULL.
Only used if input is path to gff.}
}
\value{
a TxDb object
}
\description{
Useful to allow fast TxDb loader like .db
}
\examples{
library(GenomicFeatures)
# Get the gtf txdb file
txdbFile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                        package = "GenomicFeatures")
txdb <- loadTxdb(txdbFile)

}
