% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_features.R
\name{isInFrame}
\alias{isInFrame}
\title{Find frame for each orf relative to cds}
\usage{
isInFrame(dists)
}
\arguments{
\item{dists}{a vector of integer distances between ORF and cds.
0 distance means equal frame}
}
\value{
a logical vector
}
\description{
Input of this function, is the output of the function
[distToCds()], or any other relative ORF frame.
}
\details{
possible outputs:
0: orf is in frame with cds
1: 1 shifted from cds
2: 2 shifted from cds
}
\examples{
# simple example
isInFrame(c(3,6,8,11,15))

# GRangesList example
grl <- GRangesList(tx1_1 = GRanges("1", IRanges(1,10), "+"))
fiveUTRs <- GRangesList(tx1 = GRanges("1", IRanges(1,20), "+"))
dist <- distToCds(grl, fiveUTRs)
isInFrame <- isInFrame(dist)
}
\references{
doi: 10.1074/jbc.R116.733899
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToCds}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
