% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{findFa}
\alias{findFa}
\title{Convenience wrapper for Rsamtools FaFile}
\usage{
findFa(faFile)
}
\arguments{
\item{faFile}{\code{\link{FaFile}}, BSgenome, fasta/index file path or an
ORFik \code{\link{experiment}}. This file is usually used to find the
transcript sequences from some GRangesList.}
}
\value{
a \code{\link{FaFile}} or BSgenome
}
\description{
Get fasta file object, to find sequences in file.\cr
Will load and import file if necessarry.
}
\examples{
# Some fasta genome with existing fasta index in same folder
path <- system.file("extdata/references/danio_rerio", "genome_dummy.fasta", package = "ORFik")
findFa(path)

}
\seealso{
Other utils: 
\code{\link{bedToGR}()},
\code{\link{convertToOneBasedRanges}()},
\code{\link{export.bed12}()},
\code{\link{export.bigWig}()},
\code{\link{export.fstwig}()},
\code{\link{export.wiggle}()},
\code{\link{fimport}()},
\code{\link{fread.bed}()},
\code{\link{optimizeReads}()},
\code{\link{readBam}()},
\code{\link{readBigWig}()},
\code{\link{readWig}()}
}
\concept{utils}
