% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_usage.R
\name{codon_usage}
\alias{codon_usage}
\title{Codon usage}
\usage{
codon_usage(
  reads,
  cds,
  mrna,
  faFile,
  filter_table,
  filter_cds_mod3 = TRUE,
  min_counts_cds_filter = max(min(quantile(filter_table, 0.5), 1000), 1000),
  with_A_sites = TRUE,
  aligned_position = "center",
  code = GENETIC_CODE
)
}
\arguments{
\item{reads}{either a single library (GRanges, GAlignment, GAlignmentPairs),
or a list of libraries returned from \code{outputLibs(df)} with p-sites.
If list, the list must have names coresponding to the library names.}

\item{cds}{a GRangesList}

\item{mrna}{a GRangesList}

\item{faFile}{a FaFile from genome}

\item{filter_table}{a matrix / vector of length equal to cds}

\item{filter_cds_mod3}{logical, default TRUE. Remove all ORFs that are not
mod3, this speeds up the computation a lot, and usually removes malformed
ORFs you would not want anyway.}

\item{min_counts_cds_filter}{numeric, default:
\code{max(min(quantile(filter_table, 0.50), 100), 100)}.
 Minimum number of counts from the 'filter_table'  argument.}

\item{with_A_sites}{logical, default TRUE. Not used yet, will also return
A site scores.}

\item{aligned_position}{what positions should be taken to calculate per-codon coverage.
By default: "center", meaning that positions -1,0,1 will be taken.
Alternative: "left", then positions 0,1,2 are taken.}

\item{code}{a named character vector of size 64. Default: GENETIC_CODE.
Change if organism does not use the standard code.}
}
\value{
a data.table of rows per AA:codon. All values are given
per library, per site (A or P) per codon type (start, internal, stop),
sorted by the mean_txNorm_percentage column
of the first library in the set, the columns are:
\itemize{
 \item{variable (character) : Library name}
 \item{seq (character) : Amino acid:codon , for start codons: Amino acid is #, and
 stop codons are "*". So for human, there will be both #:ATG (the start sites),
 and M:ATG (internal ATGs)}
 \item{sum (integer) : total counts per seq}
 \item{sum_txNorm (integer) : total counts per seq normalized per tx}
 \item{var (numeric) : variance of total counts per seq}
 \item{N (integer) : total number of genes with this codon,
  per type (start, stop, internal codon)}
 \item{N.total (integer) : total number of codons over all genes,
  per type (start, stop, internal codon)}
 \item{mean_txNorm (numeric) : Default use output, the fair codon usage,
 normalized both for gene and genome level for codon and read counts}
 \item{mean_txNorm_percentage : Percentage transform of mean_txNorm}
 \item{dispersion : (mean^2) / (var - mean)}
 \item{dispersion_txNorm : (mean_txNorm^2) / (var_txNorm - mean_txNorm)}
 \item{alpha (numeric) : dirichlet alpha MOM estimator (imagine mean and
           variance of probability in 1 value, the lower the value,
           the higher the variance, mean is decided by the relative
           value between samples)}
 \item{sum_txNorm (integer) : total counts per seq normalized per tx}
 \item{relative_to_max_score (integer) : Max scaled percentage of mean_txNorm_percentage,
 so percentage on the ratio of mean_txNorm_percentage / max(mean_txNorm_percentage)}
 \item{type (factor(character)) : "P" or "A"}
}
}
\description{
Per AA / codon, analyse the coverage, get a multitude of features.
For both A sites and P-sites (Input reads must be P-sites for now)
This function takes inspiration from the codonDT paper, and among
others returns the negative binomial estimates, but in addition many
other features.
}
\details{
The primary column to use is "mean_txNorm", this is the fair normalized
score.
}
\examples{
df <- ORFik.template.experiment()[9:10,] # Subset to 2 Ribo-seq libs

## For single library
reads <- fimport(filepath(df[1,], "pshifted"))
cds <- loadRegion(df, "cds", filterTranscripts(df))
mrna <- loadRegion(df, "mrna", names(cds))
filter_table <- assay(countTable(df, type = "summarized")[names(cds)])
faFile <- findFa(df)
res <- codon_usage(reads, cds, mrna, faFile = faFile,
             filter_table = filter_table, min_counts_cds_filter = 10)
}
\references{
https://www.ncbi.nlm.nih.gov/pmc/articles/PMC7196831/
}
\seealso{
Other codon: 
\code{\link{codon_usage_exp}()},
\code{\link{codon_usage_plot}()}
}
\concept{codon}
