% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranges_helpers.R
\name{asTX}
\alias{asTX}
\title{Map genomic to transcript coordinates by reference}
\usage{
asTX(
  grl,
  reference,
  ignore.strand = FALSE,
  x.is.sorted = TRUE,
  tx.is.sorted = TRUE
)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} of ranges within
 the reference, grl must either have names matching, or a meta column called
'names' that gives grouping names. i.e. grl named uORF_1_ENST00001, must then
 have a names meta column with ENST00001.}

\item{reference}{a GRangesList of ranges that include grl as a subset
of ranges. Example: cds is grl and mrna can be reference}

\item{ignore.strand}{When ignore.strand is TRUE, strand is ignored in
overlaps operations (i.e., all strands are considered "+") and the
strand in the output is '*'. \cr
When ignore.strand is FALSE (default) strand in the output is taken from the
transcripts argument. When transcripts is a GRangesList, all inner list
elements of a common list element must have the same strand
or an error is thrown. \cr
Mapped position is computed by counting from the transcription start site
 (TSS) and is not affected by the value of ignore.strand.}

\item{x.is.sorted}{if x is a GRangesList object, are "-" strand groups pre-sorted
in decreasing order within group, default: TRUE}

\item{tx.is.sorted}{if transcripts is a GRangesList object,
are "-" strand groups pre-sorted in decreasing order within group,
default: TRUE}
}
\value{
a GRangesList in transcript coordinates
}
\description{
Map range coordinates between features in the genome and
transcriptome (reference) space.
}
\details{
Similar to GenomicFeatures' pmapToTranscripts, but in this version the
grl ranges are compared to reference ranges with same name, not
by index. This gives a large speedup, but also requires
all objects must be named.
}
\examples{
seqname <- c("tx1", "tx2", "tx3")
seqs <- c("ATGGGTATTTATA", "AAAAA", "ATGGGTAATA")
grIn1 <- GRanges(seqnames = "1",
                 ranges = IRanges(start = c(21, 10), end = c(23, 19)),
                 strand = "-")
grIn2 <- GRanges(seqnames = "1",
                 ranges = IRanges(start = c(1), end = c(5)),
                 strand = "-")
grIn3 <- GRanges(seqnames = "1",
                 ranges = IRanges(start = c(1010), end = c(1019)),
                 strand = "-")
grl <- GRangesList(grIn1, grIn2, grIn3)
names(grl) <- seqname
# Find ORFs
test_ranges <- findMapORFs(grl, seqs,
                 "ATG|TGG|GGG",
                 "TAA|AAT|ATA",
                 longestORF = FALSE,
                 minimumLength = 0)
# Genomic coordinates ORFs
test_ranges
# Transcript coordinate ORFs
asTX(test_ranges, reference = grl)
# seqnames will here be index of transcript it came from

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{extendTrailers}()},
\code{\link{reduceKeepAttr}()},
\code{\link{tile1}()},
\code{\link{txSeqsFromFa}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
