% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SummarizedExperiment_helpers.R
\name{scoreSummarizedExperiment}
\alias{scoreSummarizedExperiment}
\title{Helper function for makeSummarizedExperimentFromBam}
\usage{
scoreSummarizedExperiment(
  final,
  score = "transcriptNormalized",
  collapse = FALSE
)
}
\arguments{
\item{final}{ranged summarized experiment object}

\item{score}{default: "transcriptNormalized"
(row normalized raw counts matrix),
alternative is "fpkm", "log2fpkm" or "log10fpkm"}

\item{collapse}{a logical/character (default FALSE), if TRUE all samples
within the group SAMPLE will be collapsed to one. If "all", all
groups will be merged into 1 column called merged_all. Collapse is defined
as rowSum(elements_per_group) / ncol(elements_per_group)}
}
\value{
a DEseq summerizedExperiment object (transcriptNormalized)
 or matrix (if fpkm input)
}
\description{
If txdb or gtf path is added, it is a rangedSummerizedExperiment
For FPKM values, DESeq2::fpkm(robust = FALSE) is used
}
