% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general_plots.R
\name{TOP.Motif.ecdf}
\alias{TOP.Motif.ecdf}
\title{TOP Motif ecdf plot}
\usage{
TOP.Motif.ecdf(
  seqs,
  rate,
  start = 1,
  stop = max(nchar(seqs)),
  xlim = c("q10", "q99"),
  type = "Scanning efficiency",
  legend.position.1st = c(0.75, 0.28),
  legend.position.motif = c(0.75, 0.28)
)
}
\arguments{
\item{seqs}{the sequences (character vector, DNAStringSet),
of 5' UTRs (leaders). See example below for input.}

\item{rate}{a scoring vector (equal size to seqs)}

\item{start}{position in seqs to start at (first is 1), default 1.}

\item{stop}{position in seqs to stop at (first is 1),
default max(nchar(seqs)), that is the longest sequence length}

\item{xlim}{What interval of rate values you want to show
type: numeric or quantile of length 2,
1. default c("q10","q99"). bigger than 10 percentile
 and less than 99 percentile.
2. Set to numeric values, like c(5, 1000),
3. Set to NULL if you want all values. Backend uses coord_cartesian.}

\item{type}{What type is the rate scoring ? default ("Scanning efficiency")}

\item{legend.position.1st}{adjust left plot label position, default c(0.75, 0.28),
("none", "left", "right", "bottom", "top", or two-element numeric vector)}

\item{legend.position.motif}{adjust right plot label position, default c(0.75, 0.28),
("none", "left", "right", "bottom", "top", or two-element numeric vector)}
}
\value{
a ggplot gtable of the TOP motifs in 2 plots
}
\description{
Given sequences, DNA or RNA.
And some score, scanning efficiency (SE), ribo-seq fpkm, TE etc.
}
\details{
Top motif defined as a TSS of C and 4 T's or C's (pyrimidins) downstream
of TSS C.

The right plot groups:
C nucleotide, TOP motif (C, then 4 pyrimidines) and
OTHER (all other TSS variants).
}
\examples{

\dontrun{
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg19")) {
  txdbFile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                          package = "GenomicFeatures")
  #Extract sequences of Coding sequences.
  leaders <- loadRegion(txdbFile, "leaders")

  # Should update by CAGE if not already done
  cageData <- system.file("extdata", "cage-seq-heart.bed.bgz",
                          package = "ORFik")
  leadersCage <- reassignTSSbyCage(leaders, cageData)
  # Get region to check
  seqs <- startRegionString(leadersCage, NULL,
        BSgenome.Hsapiens.UCSC.hg19::Hsapiens, 0, 4)
  # Some toy ribo-seq fpkm scores on cds
  set.seed(3)
  fpkm <- sample(1:115, length(leadersCage), replace = TRUE)
  # Standard arguments
  TOP.Motif.ecdf(seqs, fpkm, type = "ribo-seq FPKM",
                 legend.position.1st = "bottom",
                 legend.position.motif = "bottom")
  # with no zoom on x-axis:
  TOP.Motif.ecdf(seqs, fpkm, xlim = NULL,
                 legend.position.1st = "bottom",
                 legend.position.motif = "bottom")
}
}

}
