% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{QCstats.plot}
\alias{QCstats.plot}
\title{Make plot of ORFik QCreport}
\usage{
QCstats.plot(stats, output.dir = NULL, plot.ext = ".pdf", as_gg_list = FALSE)
}
\arguments{
\item{stats}{the experiment object or path to custom ORFik QC folder where a file
called "STATS.csv" is located.}

\item{output.dir}{NULL or character path, default: NULL, plot not saved to disc.
If defined saves plot to that directory with the name "/STATS_plot.pdf".}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{as_gg_list}{logical, default FALSE. Return as a list of ggplot objects
instead of as a grob. Gives you the ability to modify plots more directly.}
}
\value{
the plot object, a grob of ggplot objects of the the statistics data
}
\description{
From post-alignment QC relative to annotation, make a plot for all samples.
Will contain among others read lengths, reads overlapping leaders,
cds, trailers, mRNA / rRNA etc.
}
\examples{
df <- ORFik.template.experiment()[3,]
## First make QC report
# QCreport(df)
## Now you can get plot
# QCstats.plot(df)
}
