% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_Analysis.R
\name{te.table}
\alias{te.table}
\title{Create a TE table}
\usage{
te.table(df.rfp, df.rna, filter.rfp = 1, filter.rna = 1, collapse = FALSE)
}
\arguments{
\item{df.rfp}{a \code{\link{experiment}} of usually Ribo-seq or 80S from TCP-seq.
(the numerator of the experiment, usually having a primary role)}

\item{df.rna}{a \code{\link{experiment}} of usually RNA-seq.
(the denominator of the experiment, usually having a normalizing function)}

\item{filter.rfp}{numeric, default 1. What is the minimum fpkm value?}

\item{filter.rna}{numeric, default 1. What is the minimum fpkm value?}

\item{collapse}{a logical/character (default FALSE), if TRUE all samples
within the group SAMPLE will be collapsed to one. If "all", all
groups will be merged into 1 column called merged_all. Collapse is defined
as rowSum(elements_per_group) / ncol(elements_per_group)}
}
\value{
a data.table with 6 columns
}
\description{
Creates a data.table with 6 columns, column names are:\cr
variable, rfp_log2, rna_log2, rna_log10, TE_log2, id
}
\examples{
df <- ORFik.template.experiment()
df.rfp <- df[df$libtype == "RFP",]
df.rna <- df[df$libtype == "RNA",]
#te.table(df.rfp, df.rna)
}
\seealso{
Other DifferentialExpression: 
\code{\link{DEG.plot.static}()},
\code{\link{DEG_model}()},
\code{\link{DTEG.analysis}()},
\code{\link{DTEG.plot}()},
\code{\link{te_rna.plot}()}
}
\concept{DifferentialExpression}
