% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{save_RDSQS}
\alias{save_RDSQS}
\title{Read RDS or QS format file}
\usage{
save_RDSQS(object, file, nthread = 5)
}
\arguments{
\item{object}{the object to save}

\item{file}{path to file with "rds" or "qs" file extension}

\item{nthread}{numeric, number of threads for qs::qread}
}
\value{
R object loaded from file
}
\description{
Read RDS or QS format file
}
\examples{
path <- tempfile(fileext = ".qs")
# Simple numeric save
x <- 1
save_RDSQS(x, path)
read_RDSQS(path)
# Save a list
x <- list(a = 1, b = c(1,2,3))
save_RDSQS(x, path)
read_RDSQS(path)
}
