% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_helpers.R
\name{readWidths}
\alias{readWidths}
\title{Get read widths}
\usage{
readWidths(reads, after.softclips = TRUE, along.reference = FALSE)
}
\arguments{
\item{reads}{a GRanges, GAlignment, GAlignmentPairs or covRleList object.}

\item{after.softclips}{logical (TRUE), include softclips in width. Does not
apply if along.reference is TRUE.}

\item{along.reference}{logical (FALSE), example: The cigar "26MI2" is
by default width 28, but if along.reference is TRUE, it will be 26.
The length of the read along the reference. Also "1D20M" will be
21 if by along.reference is TRUE. Intronic regions (cigar: N) will
be removed. So: "1M200N19M" is 20, not 220.}
}
\value{
an integer vector of widths
}
\description{
Input any reads, e.g. ribo-seq object and get width of reads, this is to
avoid confusion between width, qwidth and meta column containing original
read width.
}
\details{
If input is p-shifted and GRanges, the "$size" or "$score" colum" must
exist, and the column must contain the original read widths. In ORFik
"$size" have higher priority than "$score" for defining length.
ORFik P-shifting creates a $size column, other softwares like shoelaces
creates a score column.

Remember to think about how you define length. Like the question:
is a Illumina error mismatch sufficient to reduce size of read and how
do you know what is biological variance and what are Illumina errors?
}
\examples{
gr <- GRanges("chr1", 1)
readWidths(gr)

# GAlignment with hit (1M) and soft clipped base (1S)
ga <- GAlignments(seqnames = "1", pos = as.integer(1), cigar = "1M1S",
 strand = factor("+", levels = c("+", "-", "*")))
readWidths(ga) # Without soft-clip bases

readWidths(ga, after.softclips = FALSE) # With soft-clip bases

}
