% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_extend.R
\name{extendLeaders}
\alias{extendLeaders}
\title{Extend the leaders transcription start sites.}
\usage{
extendLeaders(
  grl,
  extension = 1000L,
  cds = NULL,
  is.circular = all(isCircular(grl) \%in\% TRUE)
)
}
\arguments{
\item{grl}{usually a \code{\link{GRangesList}} of 5' utrs or transcripts.
Can be used for any extension of groups.}

\item{extension}{an integer, how much to max extend upstream (5' end).
Either single value that will apply for all, or same as length of grl
which will give 1 update value per grl object.
Or a GRangesList where start / stops by strand are the positions
to use as new starts.
Will not cross the chromosome boundary for non circular chromosomes.}

\item{cds}{a \code{\link{GRangesList}} of coding sequences,
If you want to extend 5' leaders downstream, to catch
upstream ORFs going into cds, include it. It will add first
cds exon to grl matched by names.
Do not add for transcripts, as they are already included.}

\item{is.circular}{logical, default FALSE if not any is: all(isCircular(grl) %in% TRUE).
Where grl is the ranges checked. If TRUE, allow ranges to extend
below position 1 on chromosome. Since circular genomes can have negative coordinates.}
}
\value{
an extended GRangeslist
}
\description{
Will extend the leaders or transcripts upstream (5' end) by extension.
The extension is general not relative, that means splicing
will not be taken into account.
Requires the \code{grl} to be sorted beforehand,
use \code{\link{sortPerGroup}} to get sorted grl.
}
\examples{
library(GenomicFeatures)
samplefile <- system.file("extdata", "hg19_knownGene_sample.sqlite",
                          package = "GenomicFeatures")
txdb <- loadDb(samplefile)
fiveUTRs <- fiveUTRsByTranscript(txdb, use.names = TRUE) # <- extract only 5' leaders
tx <- exonsBy(txdb, by = "tx", use.names = TRUE)
cds <- cdsBy(txdb,"tx",use.names = TRUE)
## extend leaders upstream 1000
extendLeaders(fiveUTRs, extension = 1000)
## now try(extend upstream 1000, add all cds exons):
extendLeaders(fiveUTRs, extension = 1000, cds)

## when extending transcripts, don't include cds' of course,
## since they are already there
extendLeaders(tx, extension = 1000)
## Circular genome (allow negative coordinates)
circular_fives <- fiveUTRs
isCircular(circular_fives) <- rep(TRUE, length(isCircular(circular_fives)))
extendLeaders(circular_fives, extension = 32672841L)

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendTrailers}()},
\code{\link{reduceKeepAttr}()},
\code{\link{tile1}()},
\code{\link{txSeqsFromFa}()},
\code{\link{windowPerGroup}()}
}
\concept{ExtendGenomicRanges}
