% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_helpers.R
\name{codonSumsPerGroup}
\alias{codonSumsPerGroup}
\title{Get read hits per codon}
\usage{
codonSumsPerGroup(grl, reads, weight = "score", is.sorted = FALSE)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} of 5' utrs, CDS, transcripts, etc.}

\item{reads}{a \code{\link{GAlignments}}, \code{\link{GRanges}}, or
precomputed coverage as \code{\link{covRle}} (one for each strand) of
RiboSeq, RnaSeq etc.\cr Weigths for scoring is default the 'score'
column in 'reads'. Can also be random access paths to bigWig or fstwig file.
Do not use random access for more than a few genes, then loading the entire files
is usually better. File streaming is still in beta, so use with care!}

\item{weight}{(default: 'score'), if defined a character name
of valid meta column in subject. GRanges("chr1", 1, "+", score = 5),
would mean score column tells that this alignment region was found 5 times.
Formats which loads a score column like this:
Bigwig, wig, ORFik ofst, collapsed bam, bedoc and .bedo.
As do CAGEr CAGE files and many other package formats.
You can also assign a score column manually.}

\item{is.sorted}{logical (FALSE), is grl sorted. That is + strand groups in
increasing ranges (1,2,3), and - strand groups in decreasing ranges (3,2,1)}
}
\value{
a data.table with codon sums
}
\description{
Helper for entropy function, normally not used directly
Seperate each group into tuples (abstract codons)
Gives sum for each tuple within each group
}
\details{
Example: counts c(1,0,0,1), with reg_len = 2, gives
c(1,0) and c(0,1), these are summed and returned as data.table
10 bases, will give 3 codons, 1 base codons does not exist.
}
\keyword{internal}
