% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_rank_givenEffect.R
\name{prob_rank_givenEffect}
\alias{prob_rank_givenEffect}
\title{Probability of rank of test given effect size}
\usage{
prob_rank_givenEffect(k, et, ey, nrep = 10000, m0, m1)
}
\arguments{
\item{k}{Integer, rank of a test}

\item{et}{Numeric, effect of the targeted test for importance sampling}

\item{ey}{Numeric, mean filter efffect from the external information}

\item{nrep}{Integer, number of replications for importance sampling}

\item{m0}{Integer, number of true null hypothesis}

\item{m1}{Integer, number of true alternative hypothesis}
}
\value{
\code{prob} Numeric, probability of the rank of a test
}
\description{
Comnpute the probability of rank of a
test being higher than any other tests given the effect size from external
information.
}
\details{
If one wants to test \deqn{H_0: epsilon_i=0 vs. H_a: epsilon_i > 0,}
then \code{ey} should be mean of the filter effect sizes,
This is called hypothesis testing for the continuous effect sizes.\cr

If one wants to test \deqn{H_0: epsilon_i=0 vs. H_a: epsilon_i = epsilon,}
then \code{ey} should be median or any discrete value of the
filter effect sizes. This is called hypothesis testing for the Binary
effect sizes.\cr

If \code{monitor = TRUE} then a window will open to see the progress of the
computation. It is useful for a large number of tests

\code{m1} and \code{m0} can be estimated using \code{qvalue} from
a bioconductor package \code{qvalue}.
}
\examples{
# compute the probability of the rank of a test being third if all tests are
# from the true null
prob <- prob_rank_givenEffect(k = 3, et = 0, ey = 0, nrep = 10000,
                                      m0 = 50, m1 = 50)

# compute the probabilities of the ranks of a test being rank 1 to 100 if the
# targeted test effect is 2 and the overall mean filter effect is 1.
ranks <- 1:100
prob <- sapply(ranks, prob_rank_givenEffect, et = 2, ey = 1, nrep = 10000,
                              m0 = 50, m1 = 50)

# plot
plot(ranks,prob)

}
\seealso{
\code{\link{dnorm}} \code{\link{pnorm}} \code{\link{rnorm}}
\code{\link{qvalue}}
}
\author{
Mohamad S. Hasan, shakilmohamad7@gmail.com
}
