\name{m2v}	
\alias{m2v} 
\title{Converts matrix to vector based on spot layout }
\description{This function converts a matrix based on the spatial layout of spots to a vector. Optionally,
a 2D-plot is produced.}
\usage{m2v(M,Ngc,Ngr,Nsc,Nsr,visu=FALSE,color.lim=c(-1,1),xlab="Columns",ylab="Rows",...)}
\arguments{\item{M}{Matrix of real values }
      \item{Ngc}{number of columns for the grid matrix}
      \item{Ngr}{number of rows for the grid matrix}
      \item{Nsc}{number of columns for the spot matrix}
      \item{Nsr}{number of rows for the spot matrix}
      \item{visu}{If TRUE, MXY plot is generated.} 
      \item{color.lim}{limits of colour range for 2D-plot}
      \item{xlab}{label of x -axis of 2D-plot}
      \item{ylab}{label of y-axis of 2D-plot}
      \item{...}{Further optional parameters  for the \code{image} function generating the MXY plot}
}
\details{The function \code{m2v} rearranges the values of  a matrix \code{M} corresponding to the intensity values
        on the array  to a vector \code{V}. The matrix \code{M} may have been generated by e.g.
         \code{v2m}. The order of values in \code{V} follows the convention of \emph{marrayRaw} objects. 
          In fact, the transformation of \code{m2v} is the reverse of \code{v2m} (assuming the  arguments
         are kept the same.)
         Note that these functions assume a specific mapping between the data points and the location of spot (i.e.
         the same mapping rule that is used for \emph{marrayRaw/marrayNorm} objects.) The validity of the mappings should be 
         carefully checked (see also the documentation of the \emph{marray} package.)  
         The option for spatial visualisation
         is rather restricted to logged fold-changes as the corresponding colour range is centred around zero and
         follows the conventional colouring (green for negative, red for positive fold-changes). The MXY plot produced
         by \code{m2v} does not include a colour-bar. To have a colour included, \code{mxy.plot} can be used.  
         }

\value{A vector \code{V} of length  \code{((Ngc*Nsc)*(Ngr*Nsr))} is produced. The values of \code{V} represents the spatial
        distribution of the values of vector \code{V} given the print-layout. Optionally, a 2D-plot of \code{M} is generated. }
\author{Matthias E. Futschik (\url{http://itb.biologie.hu-berlin.de/~futschik})}
\seealso{\code{\link{v2m}}, \code{\link{mxy.plot}}}
\examples{

# LOADING DATA NOT-NORMALISED
data(sw) 
# CONVERSION FROM VECTOR TO MATRIX
M <- v2m(maM(sw)[,1],Ngc=maNgc(sw),Ngr=maNgr(sw),Nsc=maNsc(sw),Nsr=maNsr(sw),visu=TRUE)

# BACK-CONVERSION FROM MATRIX TO VECTOR
V <- m2v(M,Ngc=maNgc(sw),Ngr=maNgr(sw),Nsc=maNsc(sw),Nsr=maNsr(sw),visu=TRUE)
}

\keyword{manip}



