% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{listPredefinedDataSets}
\alias{listPredefinedDataSets}
\title{List predefined datasets}
\usage{
listPredefinedDataSets()
}
\value{
\code{character} vector.
}
\description{
Use \code{listPredefinedDataSets()} to receive a vector of names for predefined
datasets that can be aquired from AnnotationHub that are already correctly
parsed and formatted. Each of the listed names can be used as input for
\code{addDataSetFromHub()}. Currently supported:
\itemize{
\item protCodingGenes - Protein coding genes from HG19 (GRCh37) Ensembl
For additional information use:
\code{getInfoOnIds(AnnotationHub(), "AH10684")}
\item CGI - CpG islands from HG19 UCSC
For additional information use:
\code{getInfoOnIds(AnnotationHub(), "AH5086")}
\item SNP - Common Single Nucleotide Polymorphism from HG19 UCSC
For additional information use:
\code{getInfoOnIds(AnnotationHub(), "AH5105")}
\item TFBS - Transcription Factor Binding Sites conserved from HG19 UCSC
For additional information use:
\code{getInfoOnIds(AnnotationHub(), "AH5090")}
\item Promoters - Promoter and flanking regions from HG19 Ensembl (Note:
This annotation is currently not included in AnnotationHub and is therefore
downloaded from Ensembl's ftp site)
}
}
\examples{
listPredefinedDataSets()
}
