% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNearest.R
\name{setParameters}
\alias{setParameters}
\title{Set the parameters}
\usage{
setParameters(type, value)
}
\arguments{
\item{type}{List of parameter names}

\item{value}{New values for the parameters. Value and the parameter names
must be in the same order.}
}
\value{
changed parameters
}
\description{
Parameters:
upstream: Upstream distance from the transcription start position
downstream: Downstream distance from the transcription end position
searchRegion: Search space of the cis-region. Possible values are
    "all", "exon", "intron"
GOtype: Hierarchical category of the GO ontology. Possible values
    are "BP", "CC", "MF"
pCut: Threshold value for the pvalue. Default value is 0.05
pAdjCut: Cutoff value for the adjusted p-values using one of given
    method. Default value is 0.05.
pAdjust: Methods of the adjusted p-values. Possible methods are
    "holm", "hochberg", "hommel", "bonferroni", "BH", "BY","fdr", "none"
min: Minimum number of genes that are required for enrichment. By
    default, this value is set to 5.
cellline: Cell lines for TAD regions.
corrMethod Correlation coeffient method that will be used for
    evaluation. Possible values are "pearson", "kendall", "spearman"
varCutoff: Variance cutt off that genes have less variance than this
    value will be trimmed
pcut: P-value cut off for the correlation values
alternate: Holds the alternative hypothesis and "two.sided", "greater"
    or "less" are the possible values.
conf: Confidence level for the returned confidence interval. It is
    only used for the Pearson correlation coefficient if there are at
    least 4 complete pairs of observations.
minAbsCor: Cut-off value for the Pearson correlation coefficient of
    the miRNA-mRNA
pathwayType: Pathway database for enrichment. Possible values are
    'reactome' for Reactome, 'kegg' for KEGG, 'wiki' for WikiPathways,
    'other' for custom database
enrichTest: Types of enrichment methods to perform enrichment
     analysis. Possible values are "hyper"(default), "binom", "fisher",
     "chi".
isSymbol: Boolean variable that hold the gene format of the gmt file.
     If it is set as TRUE, gene format of the gmt file should be symbol.
     Otherwise, gene format should be ENTREZ ID. By default, it is FALSE.
}
\examples{
\dontrun{
type <- c('downstream','upstream')

value <- c(2000,30000)

setParameters(type,value)
}

}
