% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirnaEnrichment.R
\name{mirnaPathwayEnricher}
\alias{mirnaPathwayEnricher}
\title{Pathway enrichments of the microRNA genes with mRNAs that fall in the
given upstream/downstream regions of the microRNA genes}
\usage{
mirnaPathwayEnricher(
  gene,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3"),
  near = FALSE,
  target = FALSE,
  isTADSearch = FALSE,
  TAD = c(tad_hg19, tad_dmel, tad_hg38, tad_mm10),
  gmtName = "",
  express = FALSE,
  isCustomExp = FALSE,
  cancer,
  exp1,
  exp2,
  label1 = "",
  label2 = "",
  isUnionCorGene = FALSE,
  databaseFile,
  isGeneEnrich = FALSE
)
}
\arguments{
\item{gene}{Input microRNA gene. It supports both pre-miRNA and mature miRNA,
however, when target prediction is performed(target= TRUE), miRNA genes
should be mature.}

\item{org_assembly}{Genome assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}

\item{near}{Boolean value presents whether cis-neighbourhood should be
considered in the analysis}

\item{target}{Boolean value shows whether miRNA target prediction should
be performed}

\item{isTADSearch}{Boolean value that shows whether TAD analysis is
performed. This value has to be TRUE for TAD analysis.}

\item{TAD}{TAD genomic regions for the species. Predefined TAD regions or
any new TAD regions can be used for the analysis. TAD regions must be
formated as GRanges object. Predefined TAD regions are 'tad_hg19',
'tad_hg38', 'tad_mm10', 'tad_dmel' for hg19, hg38, mm9 and dm6
assembly, respectively.}

\item{gmtName}{Custom pathway gmt file}

\item{express}{Boolean variable whether co-expression analysis is performed.
If this option is set to TRUE, co-expression analysis will be
performed.}

\item{isCustomExp}{Boolean variable whether co-expression analysis with
custom data will be performed. When this option is set, exp1 and exp2
parameters must be defined.}

\item{cancer}{Defines the name of the TCGA project code such as 'BRCA' for
correlation analysis. Possible cancer types ACC, BLCA, BRCA, CESC,
CHOL, COAD, COADREAD, DLBC, ESCA, GBMLGG, HNSC, KICH, KIPAN, KIRC,
KIRP, LGG, LIHC, LUAD, LUSC, OV, PAAD, PCPG, PRAD, READ, SARC, SKCM,
STAD, STES, TGCT, THCA, THYM, UCEC, UCS, UVM}

\item{exp1}{Custom expression data matrix. Columns must be genes and rows
must be patients. If gene names are provided as header, no need to
redefine the headers(labels) of the expression data.}

\item{exp2}{Custom expression data matrix. Columns must be genes and rows
must be patients. If gene names are provided as header, no need to
redefine the headers(labels) of the expression data.}

\item{label1}{Gene names of the custom exp1 expression data. If it is not
provided, column name of the exp1 data will be taken.}

\item{label2}{Gene names of the custom exp2 expression data. If it is not
provided, column name of the exp2 data will be taken.}

\item{isUnionCorGene}{Boolean value that shows whether union of the output
of the co-expression analysis and the other analysis should be
considered}

\item{databaseFile}{Path of miRcancer.db file}

\item{isGeneEnrich}{Boolean value whether gene enrichment should be
performed}
}
\value{
MiRNA pathway enrichment object for the given input
}
\description{
Pathway enrichments of the microRNA genes with mRNAs that fall in the
given upstream/downstream regions of the microRNA genes
}
\examples{
\dontrun{
miPath <- mirnaPathwayEnricher(gene = brain_mirna,
                               org_assembly = 'hg19',
                               near = TRUE)
}

}
