% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNearest.R
\name{getUCSC}
\alias{getUCSC}
\title{Get nearest genes for the window of the upstream/downstream region.}
\usage{
getUCSC(
  bedfile,
  upstream,
  downstream,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3")
)
}
\arguments{
\item{bedfile}{Bed formated input gene regions}

\item{upstream}{Maximum upstream distance from the transcription start
region of the input gene}

\item{downstream}{Maximum downstream distance from the transcription end
region of the input gene}

\item{org_assembly}{genomee assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}
}
\value{
genes
}
\description{
When downstream = 0 / upstream = 0, function converts bed formated regions
to HUGO genes
}
\examples{
 \dontrun{
regions<-system.file("extdata", "ncRegion.txt", package = "NoRCE")
regionNC <- rtracklayer::import(regions, format = "BED")

neighbour <- getUCSC(bedfile = regionNC,
                     upstream = 1000,
                     downstream = 1000,
                     org_assembly = 'hg19') 
                     }

}
