% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNearest.R
\name{getNearToIntron}
\alias{getNearToIntron}
\title{Get only those neighbouring genes that fall within intron region}
\usage{
getNearToIntron(
  bedfile,
  upstream,
  downstream,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3")
)
}
\arguments{
\item{bedfile}{Bed file}

\item{upstream}{upstream distance}

\item{downstream}{downstream distance}

\item{org_assembly}{genomee assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}
}
\value{
genes
}
\description{
Get only those neighbouring genes that fall within intron region
}
\examples{
\dontrun{
regions<-system.file("extdata", "ncRegion.txt", package = "NoRCE")
regionNC <- rtracklayer::import(regions, format = "BED")

r<-getNearToExon(bedfile = regionNC,
                 upstream = 1000,
                 downstream = 2000,
                 org_assembly = 'hg19')
}
}
