% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{createNetwork}
\alias{createNetwork}
\title{Create interaction network for top n enriched GO term:coding RNA or GO-term:noncoding RNA interaction.
Nodes are GO term and RNA, edges are interactions between them. Each
GO-term is annotated and enriched with the mRNAs provided from the input
list.}
\usage{
createNetwork(
  mrnaObject,
  type = "pvalue",
  n,
  isNonCode = FALSE,
  takeID = FALSE
)
}
\arguments{
\item{mrnaObject}{Output of enrichment results}

\item{type}{Sort in terms of p-values or FDR. Possible values
"pvalue", "padjust"}

\item{n}{Number of top enrichments}

\item{isNonCode}{Boolean value that checks whether node of the network is
GO-term for coding or GO-term for noncoding genes. By default, it is FALSE
so node of the network is GO-term\& coding gene. Otherwise, nodes are
GO-term for noncoding genes.}

\item{takeID}{Boolean value that checks the name decision of the GO/pathway
node, GO-term/pathway-term or GO ID-pathway ID. If it is true, name of
the GO/pathway node will be GO ID/pathway ID will be used, otherwise,
name of the GO/pathway node is GO-term. By default, it is FALSE. It is
suggested to used when the GO-term is two long or the GO-term is
missing for the custom enrichment database.}
}
\value{
Network
}
\description{
Create interaction network for top n enriched GO term:coding RNA or GO-term:noncoding RNA interaction.
Nodes are GO term and RNA, edges are interactions between them. Each
GO-term is annotated and enriched with the mRNAs provided from the input
list.
}
