% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathRank.R
\name{pathRanker}
\alias{pathRanker}
\title{Extracting and ranking paths from a network}
\usage{
pathRanker(
  graph,
  method = "prob.shortest.path",
  start,
  end,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{graph}{A weighted igraph object. Weights must be in \code{edge.weights} or \code{weight}
edge attributes.}

\item{method}{Which path ranking method to use.}

\item{start}{A list of start vertices, given by their vertex id.}

\item{end}{A list of terminal vertices, given by their vertex id.}

\item{verbose}{Whether to display the progress of the function.}

\item{...}{Method-specific parameters. See Details section.}
}
\value{
A list of paths where each path has the following items:
\item{gene}{The ordered sequence of genes visited along the path.}
\item{compounds}{The ordered sequence of compounds visited along the path.}
\item{weights}{The ordered sequence of the log(ECDF edge weights) along the path.}
\item{distance}{The sum of the log(ECDF edge weights) along each path.  (a sum of logs is a product)}
}
\description{
Given a weighted igraph object, path ranking finds a set of node/edge sequences (paths) to
maximize the sum of edge weights.
\code{pathRanker(method="prob.shortest.path")} extracts the K most probable paths within
a weighted network.
\code{pathRanker(method="pvalue")} extracts a list of paths whose sum of edge weights are
significantly higher than random paths of the same length.
}
\details{
The input here is \code{graph}. A weight must be assigned to each edge. Bootstrapped Pearson correlation edge weights
can be assigned to each edge by \code{\link{assignEdgeWeights}}. However the specification of the edge weight is flexible
with the condition that increasing values indicate stronger relationships between vertices.

\subsection{Probabilistic Shortest Paths}{
\code{pathRanker(method="prob.shortest.path")} finds the K most probable loopless paths given a weighted network.
Before the paths are ranked the edge weights are converted into probabilistic edge weights using the Empirical
Cumulative Distribution (ECDF) over all edge weights.  This is called ECDF edge weight. The ECDF edge weight
serves as a probabilistic rank of the most important gene-gene interactions.  The probabilistic nature of the ECDF
edge weights allow for a significance test to determine if a path contains any functional structure or is
simply a random walk.  The probability of a path is simily the product of all ECDF weights along the path.
This is computed as a sum of the logs of the ECDF edge weights.

The follwing arguments can be passed to \code{pathRanker(method="prob.shortest.path")}:
\describe{
\item{\code{K}}{Maximum number of paths to extract. Defaults to 10.}
\item{\code{minPathSize}}{The minimum number of edges for each extracted path. Defualts to 1.}
\item{\code{normalize}}{Specify if you want to normalize the probabilistic edge weights (across different labels)
before extracting the paths. Defaults to TRUE.}
}
}

\subsection{P-value method}{
\code{pathRanker(method="pvalue")} is deprecated. Please use \code{prob.shortest.path} instead.
}
}
\examples{
	## Prepare a weighted reaction network.
	## Conver a metabolic network to a reaction network.
 data(ex_sbml) # bipartite metabolic network of Carbohydrate metabolism.
 rgraph <- makeReactionNetwork(ex_sbml, simplify=TRUE)

	## Assign edge weights based on Affymetrix attributes and microarray dataset.
 # Calculate Pearson's correlation.
	data(ex_microarray)	# Part of ALL dataset.
	rgraph <- assignEdgeWeights(microarray = ex_microarray, graph = rgraph,
		weight.method = "cor", use.attr="miriam.uniprot",
		y=factor(colnames(ex_microarray)), bootstrap = FALSE)

	## Get ranked paths using probabilistic shortest paths.
 ranked.p <- pathRanker(rgraph, method="prob.shortest.path",
					K=20, minPathSize=6)

}
\seealso{
getPathsAsEIDs, extractPathNetwork

Other Path ranking methods: 
\code{\link{extractPathNetwork}()},
\code{\link{getPathsAsEIDs}()}
}
\author{
Timothy Hancock, Ichigaku Takigawa, Nicolas Wicker and Ahmed Mohamed
}
\concept{Path ranking methods}
