% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgseaPostprocessing.R
\name{fgseaPostprocessing}
\alias{fgseaPostprocessing}
\title{Postprocessing for GSEA analyses}
\usage{
fgseaPostprocessing(
  genesetResults,
  leadingEdge,
  limmaResults,
  join.threshold = 0.5,
  ngroups = NULL,
  dist.method = "binary",
  reportDir
)
}
\arguments{
\item{genesetResults}{Results from pathway analysis using limmaToFGSEA.}

\item{leadingEdge}{Results from fgseaToLEdge}

\item{limmaResults}{Results from runLimmaAnalysis}

\item{join.threshold}{The threshold distance to join gene sets. Gene sets 
with a distance below this value will be joined to a single "cluster."}

\item{ngroups}{The desired number of gene set groups. Either 
'join.threshold' or 'ngroups' must be specified, 'ngroups' takes priority 
if both are specified.}

\item{dist.method}{Method for distance calculation (see options for dist()).
We recommend the 'binary' (also known as Jaccard) distance.}

\item{reportDir}{Directory for the GSEA reports (each comparison will be
a separate txt file). Directory will be created if it does not exist.}
}
\value{
A table of gene set analysis results, as well as reports showing
differential expression of leading edge genes.
}
\description{
Clusters GSEA results by leading edge genes, and writes reports showing
gene expression profiles of these genes.
}
\examples{
data("ExamplePathways")
data("ExampleResults") # Results from runLimmaAnalysis

fgseaResults <- limmaToFGSEA(ExampleResults, gene.sets = ExamplePathways)

leadingEdge <- fgseaToLEdge(fgseaResults, cutoff.type = "padj", cutoff = 0.1)

\donttest{
fgseaPostprocessing(fgseaResults, leadingEdge, 
                    limmaResults = ExampleResults,
                    join.threshold = 0.5,
                    reportDir = "GSEAresults")
}
}
