% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoMethResults.R
\docType{class}
\name{NanoMethResult-class}
\alias{NanoMethResult-class}
\alias{NanoMethResult}
\alias{methy,NanoMethResult-method}
\alias{methy<-,NanoMethResult,ANY-method}
\alias{samples,NanoMethResult-method}
\alias{samples<-,NanoMethResult,data.frame-method}
\alias{exons,NanoMethResult-method}
\alias{exons<-,NanoMethResult,data.frame-method}
\title{Nanopore Methylation Result}
\usage{
NanoMethResult(methy, samples, exons = NULL)

\S4method{methy}{NanoMethResult}(object)

\S4method{methy}{NanoMethResult,ANY}(object) <- value

\S4method{samples}{NanoMethResult}(object)

\S4method{samples}{NanoMethResult,data.frame}(object) <- value

\S4method{exons}{NanoMethResult}(object)

\S4method{exons}{NanoMethResult,data.frame}(object) <- value
}
\arguments{
\item{methy}{the path to the methylation tabix file.}

\item{samples}{the data.frame of sample annotation containing at least
columns sample and group.}

\item{exons}{(optional) the data.frame of exon information containing at
least columns gene_id, chr, strand, start, end, transcript_id and symbol.}

\item{object}{the NanoMethResult object.}

\item{value}{the exon annotation.}
}
\value{
a NanoMethResult object to be used with plotting functions

the path to the methylation data.

the sample annotation.

the exon annotation.
}
\description{
A NanoMethResult object stores data used for NanoMethViz visualisation. It
contains stores a path to the methylation data, sample information and
optional exon information. The object is constructed using the
NanoMethResult() constructor function described in "Usage".
}
\section{Functions}{
\itemize{
\item \code{NanoMethResult()}: Constructor

\item \code{methy(NanoMethResult)}: methylation data path getter.

\item \code{methy(object = NanoMethResult) <- value}: methylation data path setter.

\item \code{samples(NanoMethResult)}: sample annotation getter.

\item \code{samples(object = NanoMethResult) <- value}: sample annotation setter.

\item \code{exons(NanoMethResult)}: exon annotation getter.

\item \code{exons(object = NanoMethResult) <- value}: exon annotation setter.

}}
\section{Slots}{

\describe{
\item{\code{methy}}{the path to the methylation tabix file.}

\item{\code{samples}}{the data.frame of sample annotation containing at least columns
sample and group.}

\item{\code{exons}}{the data.frame of exon information containing at least columns
gene_id, chr, strand, start, end, transcript_id and symbol.}
}}

\examples{
methy <- system.file(package = "NanoMethViz", "methy_subset.tsv.bgz", mustWork = FALSE)
sample <- c(
    "B6Cast_Prom_1_bl6",
    "B6Cast_Prom_1_cast",
    "B6Cast_Prom_2_bl6",
    "B6Cast_Prom_2_cast",
    "B6Cast_Prom_3_bl6",
    "B6Cast_Prom_3_cast"
)
group <- c(
    "bl6",
    "cast",
    "bl6",
    "cast",
    "bl6",
    "cast"
)
sample_anno <- data.frame(sample, group, stringsAsFactors = FALSE)
exon_tibble <- get_example_exons_mus_musculus()
NanoMethResult(methy, sample_anno, exon_tibble)

x <- load_example_nanomethresult()
methy(x)

}
