% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{runNPARC}
\alias{runNPARC}
\title{Non-parametric analysis of response curves}
\usage{
runNPARC(x, y, id, groupsNull = NULL, groupsAlt,
  BPPARAM = BiocParallel::SerialParam(progressbar = TRUE),
  dfType = c("theoretical", "empirical"), control = getParams())
}
\arguments{
\item{x}{numeric vector of the independent variables (typically temperature)}

\item{y}{numeric vector of the dependent variables (typically relative abundance measurements)}

\item{id}{character vector with the protein ID to which each each data point belongs.}

\item{groupsNull}{one or more vectors with grouping variables for the null models. See details.}

\item{groupsAlt}{one or more vectors with grouping variables for the alternative models. See details.}

\item{BPPARAM}{BiocParallel parameter object to invoke curve fitting in parallel. Default: BiocParallel::SerialParam()}

\item{dfType}{character value indicating the method for degrees of freedom computation for the F-test. 
Theoretical yields the text-book solution. Empirical yields estimates derived from the distribution moments of the RSS.}

\item{control}{list of parameters used to control specific parts of the analyse}
}
\value{
data frame with fitted model parameters and additional columns listing e.g. residuals sum of squares of
 null and alterantive model
}
\description{
Wrapper function for melting curve fitting and hypothesis testing.
}
\details{
\code{groupsNull} or \code{groupsAlt} can either be a single vector each, or data.frames of the same length as \code{x} and \code{y} with one column per factor
}
\examples{
data(stauro_TPP_data_tidy)
df <- dplyr::filter(stauro_TPP_data_tidy, grepl("CDK|GTP|CRK", uniqueID))
testResults <- runNPARC(x = df$temperature,
                     y = df$relAbundance,
                     id = df$uniqueID,
                     groupsAlt = df$compoundConcentration,
                     dfType = "empirical")
}
