% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{NPARCfit}
\alias{NPARCfit}
\title{Fit null and alternative models for Non-parametric analysis of response curves}
\usage{
NPARCfit(x, y, id, control = getParams(), groupsNull = NULL, groupsAlt,
  BPPARAM = BiocParallel::SerialParam(progressbar = TRUE),
  returnModels = FALSE)
}
\arguments{
\item{x}{numeric vector of the independent variables (typically temperature)}

\item{y}{numeric vector of the dependent variables (typically relative abundance measurements)}

\item{id}{character vector with the protein ID to which each each data point belongs.}

\item{control}{list of parameters used to control specific parts of the analyse}

\item{groupsNull}{one or more vectors with grouping variables for the null models. See details.}

\item{groupsAlt}{one or more vectors with grouping variables for the alternative models. See details.}

\item{BPPARAM}{BiocParallel parameter object to invoke curve fitting in parallel. Default: BiocParallel::SerialParam()}

\item{returnModels}{boolean value. If true, the fitted models are returned together with the test results}
}
\value{
data frame with fitted model parameters and additional columns listing e.g. residuals sum of squares
}
\description{
Fit melting curve and return model metrics as well as predictions for the null and alternative models.
}
\details{
\code{groupsNull} or \code{groupsAlt} can either be a single vector each, or data.frames of the same length as \code{x} and \code{y} with one column per factor
}
\examples{
data(stauro_TPP_data_tidy)
df <- dplyr::filter(stauro_TPP_data_tidy, grepl("CDK|GTP|CRK", uniqueID))
testResults <- NPARCfit(x = df$temperature,
                     y = df$relAbundance,
                     id = df$uniqueID,
                     groupsAlt = df$compoundConcentration)


}
