% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{getParams}
\alias{getParams}
\title{Control parameters for model fitting}
\usage{
getParams(start = c(Pl = 0, a = 550, b = 10), maxAttempts = 100)
}
\arguments{
\item{start}{Numeric vector of start parameters for the melting curve equation}

\item{maxAttempts}{Number of resampling steps in case of unsuccessful model fits}
}
\value{
list of two elements: 1) "start" listing the starting parameters for
 melting curve fitting, 2) "maxAttempts" listing the maximal number of attempts
 the fit should be allowed
}
\description{
Control parameters for model fitting
}
\examples{
data(stauro_TPP_data_tidy)
df <- dplyr::filter(stauro_TPP_data_tidy, grepl("MAPK|ATP|CDK|GTP|CRK", uniqueID))
testResults <- runNPARC(x = df$temperature,
                     y = df$relAbundance,
                     id = df$uniqueID,
                     groupsAlt = df$compoundConcentration,
                     dfType = "empirical",
                     control = getParams(maxAttempts = 50))

}
