% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupZscores.R
\name{groupZscores}
\alias{groupZscores}
\title{Calculate z-scores for each peak}
\usage{
groupZscores(zscore)
}
\arguments{
\item{zscore}{A vector of numeric.
It is the z-scores of ratios for each window.}
}
\value{
A data.frame with column names as "zscore", "group", "grp.zscore", 
and "pvalue".
}
\description{
Detect peaks and calculate z-scores for each peak
}
\examples{
x <- seq_len(500)
a <- 2 * 2*pi/length(x)
y <- 20 * sin(x*a)
noise1 <- 20 * 1/10 * sin(x*a*10)
zscore <- y+noise1
groupZscores(zscore)

}
