% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulativePercentage.R
\name{cumulativePercentage}
\alias{cumulativePercentage}
\title{Plot the cumulative percentage of tag allocation}
\usage{
cumulativePercentage(
  se,
  binWidth = 1e+05,
  backgroundCorrectedAssay = "bcRatio",
  ...
)
}
\arguments{
\item{se}{An object of 
\link[SummarizedExperiment:RangedSummarizedExperiment-class]{RangedSummarizedExperiment}
with assays of raw counts, transfomred ratios, background correct ratios,
smoothed ratios and z-scores. It should be an element of the output of 
\link{smoothRatiosByChromosome}.}

\item{binWidth}{numeric(1) or integer(1). The width of each bin.}

\item{backgroundCorrectedAssay}{character(1). Assays names 
for background correction ratios.}

\item{...}{Parameter not used.}
}
\value{
A list of data.frame with the cumulative percentages.
}
\description{
Plot the difference between the cumulative percentage of tag allocation in 
paired samples.
}
\examples{
library(SummarizedExperiment)
data(triplicate.count)
se <- triplicate.count
se <- log2se(se, transformation = "log2CPMRatio",
             nucleolusCols = c("N18.subsampled.srt-2.bam",
             "N18.subsampled.srt-3.bam",
             "N18.subsampled.srt.bam"),
             genomeCols = c("G18.subsampled.srt-2.bam",
             "G18.subsampled.srt-3.bam",
             "G18.subsampled.srt.bam"))
se <- smoothRatiosByChromosome(se, chr="chr18")
cumulativePercentage(se[["chr18"]])
}
\references{
Normalization, bias correction, and peak calling for ChIP-seq
Aaron Diaz, Kiyoub Park, Daniel A. Lim, Jun S. Song
Stat Appl Genet Mol Biol. Author manuscript; 
available in PMC 2012 May 3.Published in final edited form as: 
Stat Appl Genet Mol Biol. 2012 Mar 31; 11(3): 10.1515/1544-6115.1750
 /j/sagmb.2012.11.issue-3/1544-6115.1750/1544-6115.1750.xml. 
 Published online 2012 Mar 31.  doi: 10.1515/1544-6115.1750
 PMCID: PMC3342857
}
