% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_header.R
\name{read_header}
\alias{read_header}
\title{Read in file header}
\usage{
read_header(path, n = 2L, skip_vcf_metadata = FALSE, nThread = 1)
}
\arguments{
\item{path}{Filepath for the summary statistics file to be formatted. A
dataframe or datatable of the summary statistics file can also be passed
directly to MungeSumstats using the path parameter.}

\item{n}{integer. The (maximal) number of lines to read. Negative values
indicate that one should read up to the end of input on the connection.}

\item{skip_vcf_metadata}{logical, should VCF metadata be ignored}

\item{nThread}{Number of threads to use for parallel processes.}
}
\value{
First \code{n} lines of the VCF header
}
\description{
Read in file header
}
\examples{
path <- system.file("extdata", "eduAttainOkbay.txt", 
                    package = "MungeSumstats") 
header <- read_header(path = path)                    
}
