% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCApreprocessing.R
\name{PCApreprocessing}
\alias{PCApreprocessing}
\title{Reshaped dataset for factorial analysis.}
\usage{
PCApreprocessing(SEresNorm, DATAnorm = TRUE)
}
\arguments{
\item{SEresNorm}{Results of the function
\code{\link[=DATAnormalization]{DATAnormalization()}}.}

\item{DATAnorm}{\code{TRUE} or \code{FALSE}. \code{TRUE} as default.
\code{TRUE} means the function uses the normalized data.
\code{FALSE} means the function uses the raw counts data.}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresNorm} with the different elements below
\itemize{
\item information for the functions
\code{PCArealization()} and \code{PCAgraphics()}
\item a reshape of the originally dataset for the PCA analysis
(realized by the function \code{PCArealization()})
}

saved in the metadata \code{Results[[1]][[2]]} of \code{SEresNorm}.

The reshaped dataset which corresponds to a data.frame with
(\eqn{N_g+k}) columns and \eqn{N_s} rows, where
\eqn{N_g} is the number of genes, \eqn{N_s} is the number of samples and
\itemize{
\item \eqn{k=1} if samples belong to different biological condition or
time points.
In that case, the first column will contain the biological condition
or the time point associated to each sample.
\item \eqn{k=2} if samples belong to different biological condition
and time points.
In that case, the first column will contain the biological condition
and the second column the time point associated to each sample.
}

The other \eqn{N_g} columns form a sub data.frame which is a transpose of
the data.frame composed of the \eqn{N_s} numeric columns of \code{ExprData}.
}
\description{
The function generates a SummarizedExperiment class object
containing the dataset reshaped from the original dataset,
to be used by the function
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}},
which performs the Principal Component Analysis (PCA).
This function is called by the function
\code{\link[=PCArealization]{PCArealization()}},
which also calls the function
\code{\link[FactoMineR:PCA]{FactoMineR::PCA()}}.
}
\details{
All results are built from the results of our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
\examples{
## Simulation raw counts
resSIMcount <- RawCountsSimulation(Nb.Group=2, Nb.Time=3, Nb.per.GT=4,
                                   Nb.Gene=10)
## Preprocessing step
resDATAprepSE <- DATAprepSE(RawCounts=resSIMcount$Sim.dat,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=2,
                            Individual.position=3)
## Normalization
resNorm <- DATAnormalization(SEres=resDATAprepSE,
                             Normalization="rle",
                             Plot.Boxplot=FALSE,
                             Colored.By.Factors=FALSE)
##------------------------------------------------------------------------##
resPCAdata <- PCApreprocessing(SEresNorm=resNorm,
                               DATAnorm=TRUE)
}
\seealso{
The function is called by our function
\code{\link[=PCArealization]{PCArealization()}}
and uses our function
\code{\link[=DATAnormalization]{DATAnormalization()}}.
}
